// ConfigLanguageDialog̃{^{̂A상\bhȂ
#include "StdAfx.h"
#include "ConfigWikipediaDialog.h"
#include "InputLanguageCodeDialog.h"

using namespace wpts;

/*  */
System::Void ConfigWikipediaDialog::ConfigWikipediaDialog_Load(System::Object^  sender, System::EventArgs^  e)
{
	// 
	cmnAP = gcnew MYAPP::Cmn();
	config = gcnew Config(IO::Path::Combine(Application::StartupPath, IO::Path::GetFileNameWithoutExtension(Application::ExecutablePath) + ".xml"));

	// c[`bv̐ݒ
	toolTip->SetToolTip(groupBoxLanguage, cmnAP->Resource->GetString("ToolTipConfigWikipedia_GroupBoxLanguage"));
	toolTip->SetToolTip(comboBoxCode, cmnAP->Resource->GetString("ToolTipConfigWikipedia_ComboBoxCode"));
	toolTip->SetToolTip(labelCode, cmnAP->Resource->GetString("ToolTipConfigWikipedia_ComboBoxCode"));
	toolTip->SetToolTip(groupBoxStyle, cmnAP->Resource->GetString("ToolTipConfigWikipedia_GroupBoxStyle"));
	toolTip->SetToolTip(textBoxXml, cmnAP->Resource->GetString("ToolTipConfigWikipedia_TextBoxXml"));
	toolTip->SetToolTip(labelXml, cmnAP->Resource->GetString("ToolTipConfigWikipedia_TextBoxXml"));
	toolTip->SetToolTip(textBoxRedirect, cmnAP->Resource->GetString("ToolTipConfigWikipedia_TextBoxRedirect"));
	toolTip->SetToolTip(labelRedirect, cmnAP->Resource->GetString("ToolTipConfigWikipedia_TextBoxRedirect"));
	toolTip->SetToolTip(groupBoxName, cmnAP->Resource->GetString("ToolTipConfigWikipedia_GroupBoxName"));
	toolTip->SetToolTip(groupBoxTitleKey, cmnAP->Resource->GetString("ToolTipConfigWikipedia_GroupBoxTitleKey"));
	toolStripMenuItemModify->ToolTipText = cmnAP->Resource->GetString("ToolTipConfigWikipedia_ToolStripMenuItemModify");
	toolStripMenuItemDelete->ToolTipText = cmnAP->Resource->GetString("ToolTipConfigWikipedia_ToolStripMenuItemDelete");
	dataGridViewName->Columns["Code"]->ToolTipText = cmnAP->Resource->GetString("ToolTipConfigWikipediaColumn_Code");
	dataGridViewName->Columns["ArticleName"]->ToolTipText = cmnAP->Resource->GetString("ToolTipConfigWikipediaColumn_ArticleName");
	dataGridViewName->Columns["ShortName"]->ToolTipText = cmnAP->Resource->GetString("ToolTipConfigWikipediaColumn_ShortName");

	// f[^ݒ
	comboBoxCodeSelectedText = "";
	comboBoxCode->Items->Clear();
	dataGridViewName->Rows->Clear();
	dataGridViewTitleKey->Columns->Clear();
	// gp擾
	String ^showCode = System::Globalization::CultureInfo::CurrentCulture->TwoLetterISOLanguageName;
	int x = 0;
	for each(LanguageInformation ^lang in config->Languages){
		WikipediaInformation ^svr = dynamic_cast<WikipediaInformation^>(lang);
		if(svr != nullptr){
			// \^Cgݒ
			String ^name = svr->GetName(showCode);
			if(name != ""){
				name += (" (" + svr->Code + ")");
			}
			else{
				name = svr->Code;
			}
			dataGridViewTitleKey->Columns->Add(svr->Code, name);
			// \f[^ݒ
			for(int y = 0 ; y < svr->TitleKeys->Length ; y++){
				if(dataGridViewTitleKey->RowCount - 1 <= y){
					dataGridViewTitleKey->Rows->Add();
				}
				dataGridViewTitleKey[x, y]->Value = svr->TitleKeys[y];
			}
			// R{{bNXݒ
			comboBoxCode->Items->Add(svr->Code);
			// ̗
			++x;
		}
	}
	dataGridViewTitleKey->CurrentCell = nullptr;
}

/* OK{^ */
System::Void ConfigWikipediaDialog::buttonOK_Click(System::Object^  sender, System::EventArgs^  e)
{
	// ݒۑAʂ
	// \̌ݏf[^m
	comboBoxCode_SelectedIndexChanged(sender, e);
	// \̏Ԃoϐɕۑ
	// ̈̏
	for each(LanguageInformation ^lang in config->Languages){
		WikipediaInformation ^svr = dynamic_cast<WikipediaInformation^>(lang);
		if(svr != nullptr){
			Array::Resize(svr->TitleKeys, dataGridViewTitleKey->RowCount - 1);
		}
	}
	// f[^̕ۑ
	for(int x = 0 ; x < dataGridViewTitleKey->ColumnCount ; x++){
		WikipediaInformation ^svr = dynamic_cast<WikipediaInformation^>(config->GetLanguage(dataGridViewTitleKey->Columns[x]->Name));
		if(svr != nullptr){
			for(int y = 0; y < dataGridViewTitleKey->RowCount - 1; y++){
				if(dataGridViewTitleKey[x, y]->Value != nullptr){
					svr->TitleKeys[y] = dataGridViewTitleKey[x, y]->Value->ToString()->Trim();
				}
				else{
					svr->TitleKeys[y] = "";
				}
			}
		}
	}
	// \[g
	Array::Sort(config->Languages);

	// ݒt@Cɕۑ
	if(config->Save() == true){
		// ʂāAݒI
		this->Close();
	}
	else{
		// G[bZ[W\Aʂ͊J܂
		cmnAP->ErrorDialogResource("ErrorMessage_MissConfigSave");
	}
	return;
}

/* R[hR{{bNX̕ύX */
System::Void ConfigWikipediaDialog::comboBoxCode_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e)
{
	System::Diagnostics::Debug::WriteLine("ConfigLanguageDialog::_SelectedIndexChanged > "
		+ comboBoxCodeSelectedText + " -> "
		+ ((comboBoxCode->SelectedItem != nullptr) ? (comboBoxCode->SelectedItem->ToString()) : ("")));

	// ύXO̐ݒۑ
	// ύXOɂύXɂAOɒǉĂ̂GetLanguageŌȂƂ͖EEE͂
	if(comboBoxCodeSelectedText != ""){
		WikipediaInformation ^svr = dynamic_cast<WikipediaInformation^>(config->GetLanguage(comboBoxCodeSelectedText));
		if(svr != nullptr){
			svr->ArticleXmlPath = textBoxXml->Text->Trim();
			svr->Redirect = textBoxRedirect->Text->Trim();
			// \ď̂̏ۑ
			dataGridViewName->Sort(dataGridViewName->Columns["Code"], ListSortDirection::Ascending);
			svr->Names = gcnew array<LanguageInformation::LanguageName>(0);
			for(int y = 0 ; y < dataGridViewName->RowCount - 1 ; y++){
				// lĂȂƂ̓K[hĂ͂Aꉞ`FbN
				String ^code = MYAPP::Cmn::NullCheckAndTrim(dataGridViewName["Code", y]);
				if(code != ""){
					LanguageInformation::LanguageName name;
					name.Code = code;
					name.Name = MYAPP::Cmn::NullCheckAndTrim(dataGridViewName["ArticleName", y]);
					name.ShortName = MYAPP::Cmn::NullCheckAndTrim(dataGridViewName["ShortName", y]);
					MYAPP::Cmn::AddArray(svr->Names, name);
				}
			}
		}
	}
	// ύX̒lɉāAʕ\XV
	if(comboBoxCode->SelectedItem != nullptr){
		// lݒ
		WikipediaInformation ^svr = dynamic_cast<WikipediaInformation^>(config->GetLanguage(comboBoxCode->SelectedItem->ToString()));
		if(svr != nullptr){
			textBoxXml->Text = svr->ArticleXmlPath;
			textBoxRedirect->Text = svr->Redirect;
			// ď̂̏\ɐݒ
			dataGridViewName->Rows->Clear();
			for each(LanguageInformation::LanguageName name in svr->Names){
				int index = dataGridViewName->Rows->Add();
				dataGridViewName["Code", index]->Value = name.Code;
				dataGridViewName["ArticleName", index]->Value = name.Name;
				dataGridViewName["ShortName", index]->Value = name.ShortName;
			}
		}
		// ̃vpeBL
		groupBoxStyle->Enabled = true;
		groupBoxName->Enabled = true;
		// ݂̑IlXV
		comboBoxCodeSelectedText = comboBoxCode->SelectedItem->ToString();
	}
	else{
		// ̃vpeB𖳌
		groupBoxStyle->Enabled = false;
		groupBoxName->Enabled = false;
		// ݂̑IlXV
		comboBoxCodeSelectedText = "";
	}
}

/* R[hR{{bNXł̃L[ */
System::Void ConfigWikipediaDialog::comboBoxCode_KeyDown(System::Object^  sender, System::Windows::Forms::KeyEventArgs^  e)
{
	// G^[L[ꂽꍇA݂̒lꗗɖΓo^itH[JXƂ̏j
	if(e->KeyCode == Keys::Enter){
		System::Diagnostics::Debug::WriteLine("ConfigLanguageDialog::_KeyDown > " + comboBoxCode->Text);
		comboBoxCode_Leave(sender, e);
	}
}

/* R[hR{{bNXtH[JX𗣂Ƃ */
System::Void ConfigWikipediaDialog::comboBoxCode_Leave(System::Object^  sender, System::EventArgs^  e)
{
	System::Diagnostics::Debug::WriteLine("ConfigLanguageDialog::_Leave > " + comboBoxCode->Text);
	// ݂̒lꗗɖΓo^
	comboBoxCode->Text = comboBoxCode->Text->Trim()->ToLower();
	if(comboBoxCode->Text != ""){
		if(MYAPP::Cmn::AddComboBoxNewItem(comboBoxCode) == true){
			// o^ꍇoϐɂo^
			WikipediaInformation ^svr = dynamic_cast<WikipediaInformation^>(config->GetLanguage(comboBoxCode->Text));
			// ݂Ȃ͂ꉞ͊mFĒǉ
			if(svr == nullptr){
				svr = gcnew WikipediaInformation(comboBoxCode->Text);
				MYAPP::Cmn::AddArray(config->Languages, static_cast<LanguageInformation^>(svr));
				// ^̐ݒ\ɗǉ
				dataGridViewTitleKey->Columns->Add(comboBoxCode->Text, comboBoxCode->Text);
			}
			// o^lIԂɕύX
			comboBoxCode->SelectedItem = comboBoxCode->Text;
		}
	}
	else{
		// ɂƂAύXŃCxgNȂ悤Ȃ̂ŁAIɌĂ
		comboBoxCode_SelectedIndexChanged(sender, e);
	}
}

/* eł̌ď̕\tH[JX𗣂Ƃ */
System::Void ConfigWikipediaDialog::dataGridViewName_Leave(System::Object^  sender, System::EventArgs^  e)
{
	// l`FbN
	String ^codeUnsetRows = "";
	String ^nameUnsetRows = "";
	String ^redundantCodeRows = "";
	for(int y = 0 ; y < dataGridViewName->RowCount - 1 ; y++){
		// R[h́Ãf[^ɕϊ
		dataGridViewName["Code", y]->Value = MYAPP::Cmn::NullCheckAndTrim(dataGridViewName["Code", y])->ToLower();
		// R[hݒ肳ĂȂs邩H
		if(dataGridViewName["Code", y]->Value->ToString() == ""){
			if(codeUnsetRows != ""){
				codeUnsetRows += ",";
			}
			codeUnsetRows += (y + 1);
		}
		else{
			// R[hdĂȂH
			for(int i = 0 ; i < y ; i++){
				if(dataGridViewName["Code", i]->Value->ToString() == dataGridViewName["Code", y]->Value->ToString()){
					if(redundantCodeRows != ""){
						redundantCodeRows += ",";
					}
					redundantCodeRows += (y + 1);
					break;
				}
			}
			// ď̂ݒ肳ĂȂ̂ɗ̂ݒ肳ĂȂH
			if(MYAPP::Cmn::NullCheckAndTrim(dataGridViewName["ShortName", y]) != "" &&
			   MYAPP::Cmn::NullCheckAndTrim(dataGridViewName["ArticleName", y]) == ""){
				if(nameUnsetRows != ""){
					nameUnsetRows += ",";
				}
				nameUnsetRows += (y + 1);
			}
		}
	}
	// ʂ̕\
	String ^errorMessage = "";
	if(codeUnsetRows != ""){
		errorMessage += (String::Format(cmnAP->Resource->GetString("WarningMessage_UnsetCodeColumn"), codeUnsetRows));
	}
	if(redundantCodeRows != ""){
		if(errorMessage != ""){
			errorMessage += "\n";
		}
		errorMessage += (String::Format(cmnAP->Resource->GetString("WarningMessage_RedundantCodeColumn"), redundantCodeRows));
	}
	if(nameUnsetRows != ""){
		if(errorMessage != ""){
			errorMessage += "\n";
		}
		errorMessage += (String::Format(cmnAP->Resource->GetString("WarningMessage_UnsetArticleNameColumn"), nameUnsetRows));
	}
	if(errorMessage != ""){
		MessageBox::Show(errorMessage, cmnAP->Resource->GetString("WarningTitle"), MessageBoxButtons::OK, MessageBoxIcon::Warning);
		dataGridViewName->Focus();
	}
}

/* R[hR{{bNX̃ReLXgj[FR[hύX */
System::Void ConfigWikipediaDialog::toolStripMenuItemModify_Click(System::Object^  sender, System::EventArgs^  e)
{
	// IĂ錾R[hɊ֘AXV
	if(comboBoxCode->SelectedIndex != -1){
		String ^oldCode = comboBoxCode->SelectedItem->ToString();
		// ͉ʂɂĕύX̌R[h擾
		InputLanguageCodeDialog ^dialog = gcnew InputLanguageCodeDialog();
		dialog->LanguageCode = oldCode;
		if(dialog->ShowDialog() == System::Windows::Forms::DialogResult::OK){
			String ^newCode = dialog->LanguageCode;
			// oϐXV
			LanguageInformation ^lang = config->GetLanguage(oldCode);
			if(lang != nullptr){
				lang->Code = newCode;
			}
			for each(LanguageInformation ^langIndex in config->Languages){
				if(langIndex->GetType() != WikipediaInformation::typeid){
					continue;
				}
				for each(LanguageInformation::LanguageName name in langIndex->Names){
					if(name.Code == oldCode){
						name.Code = newCode;
					}
				}
			}
			// R{{bNXXV
			int index = comboBoxCode->Items->IndexOf(comboBoxCode->SelectedItem);
			comboBoxCode->Items[index] = newCode;
			// ^̐ݒ\XV
			String ^header = lang->GetName(System::Globalization::CultureInfo::CurrentCulture->TwoLetterISOLanguageName);
			if(header != ""){
				header += (" (" + newCode + ")");
			}
			else{
				header = newCode;
			}
			dataGridViewTitleKey->Columns[oldCode]->HeaderText = header;
			dataGridViewTitleKey->Columns[oldCode]->Name = newCode;
			// ʂ̏ԂXV
			comboBoxCode_SelectedIndexChanged(sender, e);
		}
		delete dialog;
	}
}

/* R[hR{{bNX̃ReLXgj[F폜 */
System::Void ConfigWikipediaDialog::toolStripMenuItemDelete_Click(System::Object^  sender, System::EventArgs^  e)
{
	// IĂ錾R[hɊ֘A폜
	if(comboBoxCode->SelectedIndex != -1){
		dataGridViewTitleKey->Columns->Remove(comboBoxCode->SelectedItem->ToString());
		// oϐ폜
		array<LanguageInformation^> ^newLanguages = gcnew array<LanguageInformation^>(0);
		for each(LanguageInformation ^lang in config->Languages){
			if(lang->Code == comboBoxCode->SelectedItem->ToString() &&
			   lang->GetType() == WikipediaInformation::typeid){
				continue;
			}
			MYAPP::Cmn::AddArray(newLanguages, lang);
		}
		config->Languages = newLanguages;
	}
	MYAPP::Cmn::RemoveComboBoxItem(comboBoxCode);
	// ʂ̏ԂXV
	comboBoxCode_SelectedIndexChanged(sender, e);
}
